/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.botania;

import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.compat.botania.ManaPlantModifier;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaGrowthCondition
extends AgriGrowthConditionRegistry.BaseGrowthCondition<Integer> {
    private static final HashMap<class_2338, WeakReference<ManaPool>> POOL_CACHE = new HashMap();

    public ManaGrowthCondition() {
        super("botania_mana", null, null);
    }

    public static ManaPool getPool(class_2338 pos, class_1937 level) {
        ManaPool pool;
        WeakReference<ManaPool> ref = POOL_CACHE.get(pos);
        if (ref == null) {
            pool = BotaniaAPI.instance().getManaNetworkInstance().getClosestPool(pos, level, 16);
            ref = new WeakReference<ManaPool>(pool);
            POOL_CACHE.put(pos, ref);
        } else {
            pool = (ManaPool)ref.get();
            if (pool == null) {
                pool = BotaniaAPI.instance().getManaNetworkInstance().getClosestPool(pos, level, 16);
                ref = new WeakReference<ManaPool>(pool);
                POOL_CACHE.put(pos, ref);
            }
        }
        return pool;
    }

    public static void removePoll(ManaReceiver pool) {
        POOL_CACHE.entrySet().removeIf(e -> ((WeakReference)e.getValue()).get() == pool);
    }

    @Override
    public AgriGrowthResponse check(AgriCrop crop, class_1937 level, class_2338 pos, int strength) {
        Optional<IAgriPlantModifier> manaModifier = crop.getPlant().getModifiers().filter(m -> m.getClass() == ManaPlantModifier.class).findFirst();
        if (manaModifier.isPresent()) {
            ManaPlantModifier modifier = (ManaPlantModifier)manaModifier.get();
            ManaPool pool = ManaGrowthCondition.getPool(pos, level);
            if (pool != null && pool.isOutputtingPower() && pool.getCurrentMana() >= modifier.cost()) {
                return AgriGrowthResponse.FERTILE;
            }
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }

    @Override
    public AgriGrowthResponse apply(AgriPlant plant, int strength, Integer value) {
        return AgriGrowthResponse.FERTILE;
    }
}

